#--------------------------------------------------------
#	Script PiXYZ STUDIO - Generate LOD Chain
#
#	This Python script is meant to be used in PiXYZ STUDIO 
#	Open the script in STUDIO Script window, and click the Execute button (CTRL+E)
#	
#	This script is an APPROXIMATE version in Python of the scenario GENERATE LOD CHAIN available in the SCENARIOS menu
#	See the API documentation for more information on that specific scenario, and on all the unitary algorithms used below
#	
#	Copyright PiXYZ Software - 2018
#--------------------------------------------------------

#Defines decimation tolerences for each LOD [Sufacic, Lineic, Normal]
LOD1 =       [1.,      0.1,    5.    ]
LOD2 =       [2.,      1.,     10.   ]

#Gets scene selection
root = scene.getSelectionedOccurrences()
if root == []:
	root = [[scene.getRoot()]]

if scene.getPolygonCount(root) == 0:
	raise Exception('This scenario works for meshes only (requires the selected parts to be tessellated first).')

#Declares 3 arrays
lods0=[]
lods1=[]
lods2=[]

partPaths = []
for child in root:
	#Gets all parts
	partPaths.extend(scene.getPartPaths(child))

#Declares array to prevent processing the same part in multiple instances
processedParts=[]

assemblyPath = []

#For each part
for partPath in partPaths:
	#Gets part id
	part = partPath[-1]
	
	#Checks if already processed
	if part in processedParts:
		continue
	processedParts.append(part)
	
	#Creates the assembly intended for part LoDs
	assembly = scene.createAssembly(core.getProperty(part, "Name"))
	instancesToDelete = []
	assemblyPaths = []
	instancesOldToNew = {}
	#Gets all occurrences for the part
	partOccurrences = scene.getOccurrencesOnSceneNode(part)
	print("partOccurrences", partOccurrences)
	#Looping through them
	for partOccurrence in partOccurrences:
		#Gets parent occurrence
		parent = scene.getOccurrenceParent(partOccurrence)
		#Gets parent path
		parentPath = scene.getScenePathFromOccurrence(parent)
		#Gets parent entity
		parentNode = parentPath[-1]
		parentType = core.getEntityTypeString(parentNode)
		assemblyPath = []
		if parentType != "Instance":
			#If parent is an assembly, directly assigns assembly to it
			scene.setParent(assembly, parentNode)
			assemblyPath = parentPath + [assembly]
		else:
			instance = parentPath[-1]
			if instance in instancesOldToNew:
				newInstance = instancesOldToNew[instance]
			else:
				#If parent is an instance, needs to recreate it instantiating assembly
				newInstance = scene.createInstance(assembly, core.getProperty(parentNode, "Name"))
				#Transfers properties from old instance to new one
				core.setProperty(newInstance, "TransformationMatrix", core.getProperty(parentNode, "TransformationMatrix"))
				core.setProperty(newInstance, "Material", core.getProperty(parentNode, "Material"))
				core.setProperty(newInstance, "Visible", core.getProperty(parentNode, "Visible"))
				#Gets old parent instance (NB: an instance parent always is an assembly)
				instanceParent = parentPath[-2]
				#Assigns new instance to old instance's parent
				scene.setParent(newInstance, instanceParent)
				instancesToDelete.append(parentPath[-1])
				instancesOldToNew[instance] = newInstance
			newInstancePath = parentPath[:-1] + [newInstance]
			newInstanceOccurrence = scene.getOccurrenceFromScenePath(newInstancePath)
			oldInstanceOccurrence = scene.getOccurrenceFromScenePath(parentPath)
			#Transferts occurrence properties from old instance to new instance
			core.setProperty(newInstanceOccurrence, "Material", core.getProperty(oldInstanceOccurrence, "Material"))
			core.setProperty(newInstanceOccurrence, "Visible", core.getProperty(oldInstanceOccurrence, "Visible"))
			assemblyPath = newInstancePath + [assembly]
		
		assemblyOccurrence = scene.getOccurrenceFromScenePath(assemblyPath)
		
		#Transferts properties from part to assembly
		core.setProperty(assemblyOccurrence, "Material", core.getProperty(partOccurrence, "Material"))
		core.setProperty(assemblyOccurrence, "Visible", core.getProperty(partOccurrence, "Visible"))
		
		assemblyPaths.append(assemblyPath)
	
	
	#Creates LODs
	lod0 = part;
	core.setProperty(lod0, "Name", core.getProperty(assembly, "Name") + "_LOD0")
	scene.setParent(lod0, assembly)
	lod1 = core.cloneEntity(part);
	core.setProperty(lod1, "Name", core.getProperty(assembly, "Name") + "_LOD1")
	scene.setParent(lod1, assembly)
	lod2 = core.cloneEntity(part);
	core.setProperty(lod2, "Name", core.getProperty(assembly, "Name") + "_LOD2")
	scene.setParent(lod2, assembly)
	
	#Adds to LOD's lists
	for assemblyPath in assemblyPaths:
		lods0.append(assemblyPath + [lod0])
		lods1.append(assemblyPath + [lod1])
		lods2.append(assemblyPath + [lod2])
	
	#Clean up all instances
	core.deleteEntities(instancesToDelete)

#Decimates LODs with specified values
sufacic, lineic, normal = LOD1
algo.decimate(lods1, sufacic, lineic, normal)
sufacic, lineic, normal = LOD2
algo.decimate(lods2, sufacic, lineic, normal)
